-- SQL schema for users and payments
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(150) NOT NULL,
  phone VARCHAR(50) DEFAULT NULL,
  email VARCHAR(150) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  status ENUM('pending','active','disabled') DEFAULT 'pending',
  mac VARCHAR(50) DEFAULT NULL,
  ip VARCHAR(50) DEFAULT NULL,
  hotspot_username VARCHAR(100) DEFAULT NULL,
  hotspot_password VARCHAR(100) DEFAULT NULL,
  expires_at DATETIME DEFAULT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS payments (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_email VARCHAR(150) NOT NULL,
  reference VARCHAR(100) NOT NULL,
  plan VARCHAR(50) DEFAULT NULL,
  amount INT DEFAULT 0,
  status VARCHAR(50) DEFAULT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
