<?php
require 'db.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
$name = $data['name'] ?? '';
$phone = $data['phone'] ?? '';
$email = $data['email'] ?? '';
$password = $data['password'] ?? '';
$mac = $data['mac'] ?? '';
$ip = $data['ip'] ?? '';
if(!$name || !$email || !$password){
    echo json_encode(['status'=>false,'message'=>'name, email and password required']);
    exit;
}
$stmt = $mysqli->prepare('SELECT id FROM users WHERE email=? LIMIT 1');
$stmt->bind_param('s', $email);
$stmt->execute();
$stmt->store_result();
if($stmt->num_rows > 0){
    echo json_encode(['status'=>false,'message'=>'User already exists, please login']);
    exit;
}
$password_hash = password_hash($password, PASSWORD_DEFAULT);
$stmt = $mysqli->prepare('INSERT INTO users (name,phone,email,password_hash,status,mac,ip,created_at) VALUES (?,?,?,?,?,?,?,NOW())');
$status = 'pending';
$stmt->bind_param('sssssss', $name,$phone,$email,$password_hash,$status,$mac,$ip);
if($stmt->execute()){
    echo json_encode(['status'=>true,'message'=>'User created','email'=>$email]);
} else {
    echo json_encode(['status'=>false,'message'=>'DB error']);
}
?>