<?php
require 'db.php';
$secret = 'sk_test_YOUR_PAYSTACK_SECRET';
$raw = file_get_contents('php://input');
$headerSignature = $_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] ?? '';
$hash = hash_hmac('sha512', $raw, $secret);
if(!hash_equals($hash, $headerSignature)){ http_response_code(400); exit('invalid signature'); }
$payload = json_decode($raw, true);
if(!isset($payload['event']) || $payload['event'] !== 'charge.success'){ http_response_code(200); exit; }
$tx = $payload['data'];
$email = $tx['customer']['email'] ?? '';
$metadata = $tx['metadata'] ?? [];
$plan = $metadata['plan'] ?? 'default';
if($plan === 'hourly'){ $profile = 'hourly-profile'; $limitUptime = '1h'; $expires = date('Y-m-d H:i:s', time() + 3600); }
else { $profile = 'daily-profile'; $limitUptime = '1d'; $expires = date('Y-m-d H:i:s', time() + 86400); }
$username = 'u'.substr(md5($email.$tx['reference']),0,8);
$password = substr(bin2hex(random_bytes(4)),0,8);
$router_ip = 'YOUR_ROUTER_PUBLIC_IP';
$router_user = 'apiuser';
$router_pass = 'apipassword';
$addUserUrl = "https://{$router_ip}/rest/ip/hotspot/user/add";
$body = ['name'=>$username,'password'=>$password,'profile'=>$profile,'limit-uptime'=>$limitUptime,'server'=>'hotspot1','comment'=>"paystack_ref:{$tx['reference']}"];
$ch = curl_init($addUserUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_USERPWD, $router_user . ':' . $router_pass);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$res = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
if($code >=200 && $code <300){
    $stmt = $mysqli->prepare('UPDATE users SET status=?, hotspot_username=?, hotspot_password=?, expires_at=? WHERE email=?');
    $status = 'active';
    $stmt->bind_param('sssss', $status, $username, $password, $expires, $email);
    $stmt->execute();
    $mac = $metadata['mac'] ?? '';
    $ip = $metadata['ip'] ?? '';
    if($mac && $ip){
        $loginUrl = "https://{$router_ip}/rest/ip/hotspot/active/login";
        $loginBody = ['user'=>$username,'password'=>$password,'mac-address'=>$mac,'ip'=>$ip];
        $ch2 = curl_init($loginUrl);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_USERPWD, $router_user . ':' . $router_pass);
        curl_setopt($ch2, CURLOPT_POST, true);
        curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($loginBody));
        curl_setopt($ch2, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_exec($ch2);
        curl_close($ch2);
    }
    http_response_code(200);
    exit;
} else {
    error_log('router add user failed: '.$res);
    http_response_code(500);
    exit;
}
?>