<?php
require 'db.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
$email = $data['email'] ?? '';
$password = $data['password'] ?? '';
$mac = $data['mac'] ?? '';
$ip = $data['ip'] ?? '';
if(!$email || !$password){ echo json_encode(['status'=>false,'message'=>'email and password required']); exit; }
$stmt = $mysqli->prepare('SELECT id,password_hash,status,hotspot_username,hotspot_password,expires_at FROM users WHERE email=? LIMIT 1');
$stmt->bind_param('s', $email);
$stmt->execute();
$res = $stmt->get_result();
if($res->num_rows === 0){ echo json_encode(['status'=>false,'message'=>'User not found']); exit; }
$row = $res->fetch_assoc();
if(!password_verify($password, $row['password_hash'])){ echo json_encode(['status'=>false,'message'=>'Invalid password']); exit; }
if($row['status'] !== 'active'){ echo json_encode(['status'=>false,'message'=>'Account not active. Please purchase a plan.']); exit; }
if($row['expires_at'] && strtotime($row['expires_at']) < time()){ echo json_encode(['status'=>false,'message'=>'Plan expired. Please purchase again.']); exit; }
$router_ip = 'YOUR_ROUTER_PUBLIC_IP';
$router_user = 'apiuser';
$router_pass = 'apipassword';
$loginUrl = "https://{$router_ip}/rest/ip/hotspot/active/login";
$loginBody = ['user'=> $row['hotspot_username'],'password'=>$row['hotspot_password'],'mac-address'=>$mac,'ip'=>$ip];
$ch = curl_init($loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_USERPWD, $router_user . ':' . $router_pass);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($loginBody));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$res = curl_exec($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
if($code >=200 && $code <300){
    echo json_encode(['status'=>true,'message'=>'Logged in']);
} else {
    echo json_encode(['status'=>false,'message'=>'Router login failed']);
}
?>