<?php
require 'db.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
$email = $data['email'] ?? '';
$plan = $data['plan'] ?? 'default';
$amount = $data['amount'] ?? 0;
if(!$email || !$amount){ echo json_encode(['status'=>false,'message'=>'email and amount required']); exit; }
$secretKey = 'sk_test_YOUR_PAYSTACK_SECRET';
$payload = json_encode([
    'email'=>$email,
    'amount'=> (int)$amount,
    'metadata'=> ['plan'=>$plan]
]);
$ch = curl_init('https://api.paystack.co/transaction/initialize');
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer '.$secretKey, 'Content-Type: application/json']);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$result = curl_exec($ch);
$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
http_response_code($httpcode);
echo $result;
?>